/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_latch ( q, data, gate,
        aset, aclr, aconst) ;

  parameter lpm_type = "lpm_latch" ;
  parameter lpm_width = 1 ;
  parameter lpm_avalue = 0 ;
  parameter polar_data   = "NORMAL" ;
  parameter polar_gate   = "NORMAL" ;
  parameter polar_aset   = "NORMAL" ;
  parameter polar_aclr   = "NORMAL" ;
  parameter polar_aconst = "NORMAL" ;
  parameter polar_q      = "NORMAL" ;

  input  [lpm_width-1:0] data ;
  input  gate, aset, aclr, aconst ;
  output [lpm_width-1:0] q ;

  // Internal nets
  reg [lpm_width-1:0] pdata ;
  reg pgate, paclr, paset, paconst ;
  reg [lpm_width-1:0] tmp_q;
  reg [lpm_width-1:0] ONES;
  integer i ;

  pulldown P1 ( aclr) ;
  pulldown P2 ( aset) ;
  pulldown P3 ( aconst) ;

  initial
  begin
	for( i=0; i < lpm_width; i=i+1 )
		ONES[i] = 1;

	tmp_q = 0 ;
  end

  always @(data)
  begin
	pdata <= #1 (polar_data == "INVERT")?~data:data  ;
  end
	
  always @(aclr)
  begin
	paclr <= #1 (polar_aclr == "INVERT")?~aclr:aclr ;
  end
	
  always @(aset)
  begin
	paset <= #1 (polar_aset == "INVERT")?~aset:aset ;
  end
	
  always @(aconst)
  begin
	paconst <= #1 (polar_aconst == "INVERT")?~aconst:aconst ;
  end
	
  always @(gate)
  begin
	pgate <= #1 (polar_gate == "INVERT")?~gate:gate ;
  end
  
  always @(pdata or paclr or paset or paconst or pgate) 
    begin
      if(paclr)
        begin
            tmp_q = 0 ;
        end
      else if(paset)
        begin
            tmp_q = ONES ;
        end
      else if(paconst)
        begin
            // check if avalue is out of bound
            if(lpm_avalue >= (1 << lpm_width))
                $display("Error! lpm_avalue is out of bound.\n");
            else if(lpm_avalue < 0)
                $display("Error! lpm_avalue must be a positive value.\n");
            else
        		tmp_q = lpm_avalue ;
        end
      else if(pgate)
        begin
            tmp_q = pdata ;
        end
    end

  assign q = (polar_q == "INVERT")? ~tmp_q: tmp_q ;
endmodule // LpM_LATCH
`ifdef SYNTH
`else
`endcelldefine
`endif
 
